#include "stdafx.h"
#include "comm.h"
#include "serial.h"
#include "tcpip.h"
#include "queue.h"

#define PACKET_LENGTH 31

char ESCAPE_CHAR=-1;
char TERM_CHAR=55;
bool stopDF=false;
bool quittrack=false;

unsigned char CP=145; // camera pan and tilt for tracking
unsigned char CT=115;


//pointers to comm structurs
serialPort *com1=NULL;
serialPort *com2=NULL;
TCPIP *TCPIP4999=NULL;
TCPIP *TCPIP5000=NULL;
TCPIP *TCPIP5001=NULL;
TCPIP *TCPIP5002=NULL;
TCPIP *TCPIP5003=NULL;


//queues
charqueue *com1_queue;
charqueue *com2_queue;
//charqueue *tcpip4999_queue; //debug
charqueue *tcpip5000_queue; //camera
charqueue *tcpip5001_queue; //rover

//global exit variable
bool bStopFollow;
bool bExit;
char rover_response[20];

void PrintDebugChar(char s) {
	if(TCPIP4999->connected()) {
		char buf[5];
		sprintf(buf,"%d",s);
		TCPIP4999->sendData(buf);
	}
}

void PrintDebugAscii(char* s, int l) {
	for(int i=0; i<l; i++) {
		PrintDebugChar(s[i]);
		PrintDebug(" ");
	}
}

void PrintDebug(char* s)
{
	if(TCPIP4999->connected()) {
		TCPIP4999->sendData(s);
	}
}

void PrintDebug2(char* s, int len)
{
	if(TCPIP4999->connected()) {
		TCPIP4999->sendData2(s,len);
	}
}

void start_comm()
{
  DWORD dwThreadID;
  HANDLE hMainThread = CreateThread (NULL, 0, MainThread, 0, 0, 
                                  &dwThreadID);
  if (hMainThread)
  {
    CloseHandle (hMainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the main thread"), 
                TEXT("Error"), MB_OK);
  }
}

DWORD MainThread(LPVOID lpvoid)
{
	com1=new serialPort(_T("COM4:"));
	com2=new serialPort(_T("COM1:"));
	TCPIP4999=new TCPIP(4999);
	TCPIP5000=new TCPIP(5000); //main camera thread
	TCPIP5001=new TCPIP(5001); //main rover thread
	TCPIP5002=new TCPIP(5002); //main camera thread
	TCPIP5003=new TCPIP(5003); //main rover thread
	bExit=false;

//createqueues
	com1_queue=new charqueue(_T("com1_queue"));
	com2_queue=new charqueue(_T("com2_queue"));
	//tcpip4999_queue=new charqueue(_T("tcpip4999_queue"));
	tcpip5000_queue=new charqueue(_T("tcpip5000_queue"));
	tcpip5001_queue=new charqueue(_T("tcpip5001_queue"));
//create threads
  DWORD dwThreadID;
  HANDLE hCom1Thread = CreateThread (NULL, 0, Com1QueueThread, 0, 0, 
                                  &dwThreadID);
  if (hCom1Thread)
  {
    CloseHandle (hCom1Thread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the com1 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }

  HANDLE hCom2Thread = CreateThread (NULL, 0, Com2QueueThread, 0, 0, 
                                  &dwThreadID);
  if (hCom2Thread)
  {
    CloseHandle (hCom2Thread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the com2 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }

  HANDLE hTCPIP5000Thread = CreateThread (NULL, 0, TCPIP5000QueueThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5000Thread)
  {
    CloseHandle (hTCPIP5000Thread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5000 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }

  HANDLE hTCPIP5001Thread = CreateThread (NULL, 0, TCPIP5001QueueThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5001Thread)
  {
    CloseHandle (hTCPIP5001Thread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5001 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }


	HANDLE hTCPIP4999MainThread = CreateThread (NULL, 0, TCPIP4999ProcessThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP4999MainThread)
  {
    CloseHandle (hTCPIP4999MainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5001 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }

	HANDLE hTCPIP5000MainThread = CreateThread (NULL, 0, TCPIP5000ProcessThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5000MainThread)
  {
    CloseHandle (hTCPIP5000MainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5001 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }

  HANDLE hTCPIP5001MainThread = CreateThread (NULL, 0, TCPIP5001ProcessThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5001MainThread)
  {
    CloseHandle (hTCPIP5001MainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5001 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }
  HANDLE hTCPIP5002MainThread = CreateThread (NULL, 0, TCPIP5002ProcessThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5002MainThread)
  {
    CloseHandle (hTCPIP5002MainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5002 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }
  HANDLE hTCPIP5003MainThread = CreateThread (NULL, 0, TCPIP5003ProcessThread, 0, 0, 
                                  &dwThreadID);
  if (hTCPIP5003MainThread)
  {
    CloseHandle (hTCPIP5003MainThread);
  }
  else
  {
    // Could not create the read thread.
    MessageBox (0, TEXT("Unable to create the tcpip5003 thread"), 
                TEXT("Error"), MB_OK);
	bExit=true;
  }
	return 0;
}

void startFollow()
{
	DWORD dwThreadID;
	HANDLE CameraFollowThread = CreateThread (NULL, 0, FollowLineProcess, 0, 0, 
														&dwThreadID);

	if (CameraFollowThread)
	{
		CloseHandle (CameraFollowThread);
	}
	else
	{
	// Could not create the read thread.
		MessageBox (0, TEXT("Unable to create the follow line thread"), 
								TEXT("Error"), MB_OK);
	}
}

void shutdown(bool restart)
{
	bExit=true;
	Sleep(250);
	if(com1!=NULL)
		delete com1;
	if(com2!=NULL)
		delete com2;
	if(TCPIP4999!=NULL)
		delete TCPIP4999;
	if(TCPIP5000!=NULL)
		delete TCPIP5000;
	if(TCPIP5001!=NULL)
		delete TCPIP5001;
	Sleep(500);
	if(restart) 
		start_comm();
}

DWORD TCPIP4999ProcessThread(LPVOID lpvoid)
{
	//should be used only for debugging
	char buffer2[4];
	char* data;
	char buffer[100];
	int position=0;
  //loop to process data
	while(!bExit) {
	  Sleep(100);
	  while(!bExit && TCPIP4999->connected()) {
		int length=TCPIP4999->recieveData(data);
		for(int i=0; i<length; i++) {			
			if(position<100) {
				buffer[position]=data[i];
				char sendbuf[2];
				sendbuf[0]=data[i];
				sendbuf[1]=NULL;
				PrintDebug(sendbuf);
				if(buffer[position]=='\n') {
					position--;
					buffer[position]=NULL;
					PrintDebug("\r\nProcessing Debug Command ");
					PrintDebug(buffer);
					PrintDebug("\r\n");
					buffer2[0]=buffer[0];
					buffer2[1]=buffer[1];
					buffer2[2]=buffer[2];
					buffer2[3]=NULL;
					if(strcmp(buffer2, "RC ")==0) {
	
						buffer[position]='\r';
						buffer[position+1]=NULL;
						PrintDebug("Sending command to camera\r\n");
						com1_queue->push(&buffer[3], CameraProcess);
					} 
					if(strcmp( buffer,"EXIT")==0) {
						PrintDebug("Exiting\r\n");
						shutdown(true);
					}
					if(strcmp( buffer,"FM")==0) {
						PrintDebug("Flushing Rover\r\n");
						com2->Flush();
					}
					if(strcmp(buffer2, "RM ")==0) {
						//movement command
						PrintDebug("Sending command to rover\r\n");
						com2_queue->push(&buffer[3], RoverProcess);
					}
					if(strcmp( buffer,"FC")==0) {
						PrintDebug("Flushing Camera\r\n");
						com1->Flush();
					}

					if(strcmp(buffer, "Follow")==0) {
						PrintDebug("Initiating Line Following\r\n");
						startFollow();
					}
					if(strcmp( buffer,"Stop")==0) {
						PrintDebug("Stopping\r\n");
						send_vel(0,NothingProcess);
						stop_follow();
						Sleep(0);
						send_vel(0,NothingProcess);
					}
					if(strcmp(buffer,"DF")==0) {
							PrintDebug("Going to dump a frame\r\n");
							com1_queue->push("DF\r",DumpFrameProcess);
					}
					if(strcmp(buffer,"STOPDF")==0) {
						stopDF=true;
					}
					if(strcmp(buffer,"STOPTRACK")==0) {
						quittrack=true;
					}
					if(strcmp(buffer2,"TR ")==0) {
						com1_queue->push(&buffer[3], TrackProcess);
					}
					position=-1;
				}

				position++;
			} else {
				position=0;
			}
			
		}  //for to go through input tcpip stream
	  }  //while we are connected
	} //while we aren't exiting
	return 0;
}

// this thread is for speaking directly to the CMUcam through the iPAQ
DWORD TCPIP5000ProcessThread(LPVOID lpvoid)
{
	bool connect=false;
	bool sawEscape=false;
	char buffer2[4];
	char* data;
	char buffer[100];
	int position=0;
	char errorBuffer[100];
  //loop to process data
	while(!bExit) {
	  Sleep(100);
	  if(TCPIP5000->connected()) {
		PrintDebug("Camera Processing Started\r\n");
	  }
	  while(!bExit && TCPIP5000->connected()) {
		connect=true;
		int length=TCPIP5000->recieveData(data);
		for(int i=0; i<length; i++) {
			if(position<100) {
				buffer[position]=data[i];
				PrintDebugChar(data[i]);
				PrintDebug(" ");
				if(sawEscape) {
					sawEscape=false;
					if(buffer[position]==ESCAPE_CHAR) {
						position--;  //kill the escape char
					} else if(buffer[position]==TERM_CHAR) {
						//do parsing
						buffer[position-1]=buffer[position]=NULL;  //kill last two escapes
						PrintDebug("\r\nProcessing Camera Command ");
						PrintDebug(buffer);
						PrintDebug("\r\n");
						buffer2[0]=buffer[0];
						buffer2[1]=buffer[1];
						buffer2[2]=buffer[2];
						buffer2[3]=NULL;
						if(strcmp(buffer2, "RC ")==0) {
							//camera command
							sprintf(errorBuffer, "Sending command to camera. %x C1Q size = %d\r\n", 
								buffer, com1_queue->size());
							PrintDebug(errorBuffer);
							com1_queue->push(&buffer[3], CameraProcess);
						} else if(strcmp( buffer,"FC")==0) {
							PrintDebug("Flushing Camera\r\n");
							com1->Flush();
							errorBuffer[0] = (char) 255;
							errorBuffer[1] = 55;
							errorBuffer[2] = 3;
							errorBuffer[3] = (char) 255;
							errorBuffer[4] = 55;
							tcpip5000_queue->push2(errorBuffer,5,NothingProcess);

						} else if(strcmp(buffer,"DF")==0) {
							PrintDebug("Going to dump a frame\r\n");
							com1_queue->push("DF\r",DumpFrameProcess);
						} else if(strcmp(buffer,"STOPDF")==0) {
							stopDF=true;
						} else if(strcmp(buffer,"STOPTRACK")==0) {
							quittrack=true;
						} else if(strcmp(buffer2,"TR ")==0) {
							// set neck position to current position commanded
							CP = buffer[3];
							CT = buffer[4];
							send_rover(0,0,0,CP,CT,IgnoreRoverProcess);
							//com1_queue->push(&buffer[3], TrackProcess); SHane version
							com1_queue->push(&buffer[5], TrackProcess);
						}
						//resets the position
						position=-1;
					}
				} else {
					//check to see if it is the escape char
					if(buffer[position]==ESCAPE_CHAR) {
						sawEscape=true;
					}
				}
				//goto the next position
				position++;
			} else {
				//we have overrun the buffer
				position=0;
			}
		}  //for to go through input tcpip stream
	  } //while we are connected
	  if(connect) {
		PrintDebug("Camera No longer connected\r\n");
		connect=false;
		quittrack=true;
	  }

	} //while we aren't exiting
	return 0;
}

// this thread is for talking to the Rover through the iPAQ

DWORD TCPIP5001ProcessThread(LPVOID lpvoid)
{
	bool connect=false;
	char buffer2[4];
	bool sawEscape=false;
	char* data;
	char buffer[100];
	int position=0;
	char errorBuffer[100];
  //loop to process data
	while(!bExit) {
	  Sleep(100);
	  if(TCPIP5001->connected()) {
	    PrintDebug("Rover Processing Started\r\n");
	  }
	  while(TCPIP5001->connected() && !bExit) {
		connect=true;
		int length=TCPIP5001->recieveData(data);
		for(int i=0; i<length; i++) {
			if(position<100) {
				buffer[position]=data[i];
				PrintDebugAscii(&buffer[position],1);
				if(sawEscape) {
					PrintDebug("InEsc ");
					sawEscape=false;
					if(buffer[position]==ESCAPE_CHAR) {
						position--;  //kill the escape char (just one of them
						PrintDebug("OnlyEsc ");
					} else if(buffer[position]==TERM_CHAR) {
						//do parsing
						buffer[position-1]=buffer[position]=NULL; 
						PrintDebug("\r\nProcessing Rover Command ");
						PrintDebug(buffer);
						PrintDebug("\r\n");
						buffer2[0]=buffer[0];
						buffer2[1]=buffer[1];
						buffer2[2]=buffer[2];
						buffer2[3]=NULL;
						if(strcmp(buffer2, "RM ")==0) {
							//movement command
							PrintDebug("\r\nSending Command to Rover\r\n");
							PrintDebugAscii(&buffer[3],position-4);
							PrintDebug("\r\n");
							// take the command (after the rm) and send it over the serial port to the rover
							// and start the RoverProcess
							com2_queue->push2(&buffer[3],position-4, RoverProcess);
							position = 0; break;
						} else if(strcmp( buffer,"FM")==0) {
							PrintDebug("Flushing Rover\r\n");
							com2->Flush();
							errorBuffer[0] = (char) 255;
							errorBuffer[1] = 55;
							errorBuffer[2] = 3;
							errorBuffer[3] = (char) 255;
							errorBuffer[4] = 55;
							tcpip5001_queue->push2(errorBuffer,5,NothingProcess);
							position = 0; break;
						} else if(strcmp(buffer, "Follow")==0) {
							PrintDebug("Initiating Line Following\r\n");
							startFollow();
							position = 0; break;
						} else if(strcmp( buffer,"Stop")==0) {
							PrintDebug("Stopping\r\n");
							send_vel(0,NothingProcess);
							stop_follow();
							position = 0; break;
						} else {
							PrintDebug("PARSE FAILED\r\n");
							errorBuffer[0] = (char) 255;
							errorBuffer[1] = 55;
							errorBuffer[2] = 1;
							errorBuffer[3] = (char) 255;
							errorBuffer[4] = 55;
							tcpip5001_queue->push2(errorBuffer,5,NothingProcess);
							position = 0; break;
						}
						position=-1;

					} else {
						PrintDebug("Saw an Escape with a bad Escape Code\r\n");
					}
				} else {
					//check to see if it is the escape char
					if(buffer[position]==ESCAPE_CHAR) {
						PrintDebug("Esc ");
						sawEscape=true;
					}
				}
				//goto the next position
				position++;

			} else {
				//wrapped the buffer length
				position=0;
			}
		}  //for to go through input tcpip stream
	  } //while we are connected
	  if(connect) {
	    PrintDebug("Rover No longer connected\r\n");
		connect=false;
	  }
	} //while we aren't exiting
	return 0;
}


DWORD TCPIP5002ProcessThread(LPVOID lpvoid)
{
	char* buffer;
	bool connect=false;
	while(!bExit) {
	  Sleep(100);
	  if(TCPIP5002->connected()) {
	    PrintDebug("Dump Frame Processing Started\r\n");
	  }
	  while(TCPIP5002->connected() && !bExit) {
		connect=true;
		TCPIP5002->recieveData(buffer);
		Sleep(100);
	  } //while we are connected
	  if(connect) {
	    PrintDebug("Dump Frame No longer connected\r\n");
		connect=false;
	  }
	} //while we aren't exiting
	return 0;
}

DWORD TCPIP5003ProcessThread(LPVOID lpvoid)
{
	char *buffer;
	bool connect=false;
	while(!bExit) {
	  Sleep(100);
	  if(TCPIP5003->connected()) {
	    PrintDebug("Tracking Processing Started\r\n");
	  }
	  while(TCPIP5003->connected() && !bExit) {
		connect=true;
		TCPIP5003->recieveData(buffer); //tells accepts thread whether or not 
		Sleep(100);
	  } //while we are connected
	  if(connect) {
	    PrintDebug("Tracking No longer connected\r\n");
		connect=false;
	  }
	} //while we aren't exiting
	return 0;
}

DWORD Com1QueueThread(LPVOID lpvoid)
{
	char temp[15];
	HANDLE handle=com1_queue->Handle();
	//camera thread
	while(!bExit)
	{
		WaitForSingleObject(handle,INFINITE);
		while(!com1_queue->empty()) {
			charelement* tmp;
			if(com1_queue->pop(tmp)) {
				PrintDebug("\r\nC1QT Really Sending ");
				PrintDebug(tmp->contents);
				sprintf(temp, "%d, %x\r\n", com1_queue->size(), temp);
				PrintDebug(" to camera.  com1q size = ");
				PrintDebug(temp);
				com1->writeString2(tmp->contents,tmp->length);
				tmp->call_back(NULL);
				delete tmp;
			}
		}	
	}
	return 0;
}

DWORD Com2QueueThread(LPVOID lpvoid)
{
	char temp[15];
	HANDLE handle=com2_queue->Handle();
	while(!bExit)
	{
		WaitForSingleObject(handle,INFINITE);
		while(!com2_queue->empty()) {
			charelement* tmp;
			if(com2_queue->pop(tmp)) {
				PrintDebug("\r\nC2QT Really Sending ");
				PrintDebugAscii(tmp->contents,tmp->length);
				sprintf(temp, "%d\r\n", com2_queue->size());
				PrintDebug(" to rover.  com2q size = ");
				PrintDebug(temp);
				com2->writeString2(tmp->contents,tmp->length);
				tmp->call_back(NULL);
				delete tmp;
			}
		}	
	}
	return 0;
}


DWORD TCPIP5000QueueThread(LPVOID lpvoid)
{
	HANDLE handle=tcpip5000_queue->Handle();
	while(!bExit)
	{
		WaitForSingleObject(handle,INFINITE);
		while(!tcpip5000_queue->empty()) {
			charelement* tmp;
			if(tcpip5000_queue->pop(tmp)) {
				PrintDebug("Sending Data on tcpip5000\r\n");
				TCPIP5000->sendData2(tmp->contents,tmp->length);
				tmp->call_back(NULL);
				delete tmp;
			}
		}	
		
	}
	return 0;
}

DWORD TCPIP5001QueueThread(LPVOID lpvoid)
{
	HANDLE handle=tcpip5001_queue->Handle();
	while(!bExit)
	{
		WaitForSingleObject(handle,INFINITE);
		while(!tcpip5001_queue->empty()) {
			charelement* tmp;
			if(tcpip5001_queue->pop(tmp)) {
				PrintDebug("Sending Data on tcpip5001\r\n");
				PrintDebug("Data being sent is: ");
				PrintDebugAscii(tmp->contents,tmp->length);
				PrintDebug("\r\n");

				TCPIP5001->sendData2(tmp->contents,tmp->length);
				tmp->call_back(NULL);
				delete tmp;
			}
		}	
		
	}
	return 0;
}


DWORD NothingProcess(LPVOID lpvoid)
{
	return 0;
}

DWORD CameraProcess(LPVOID lpvoid)
{
	//this thread waits for a ':', 96 bits of information or times out after ~200ms
	PrintDebug("Starting camera process\r\n");
	Sleep(0);
	bool flag=false;
	char buf[100];
	char buf2[200];
	int i=2;
	buf[0]=ESCAPE_CHAR;
	buf[1]=TERM_CHAR;
	buf[i]=0;
	int timeout=0;
	while(i<96 && !flag) {
		if(!com1->readByte(buf[i])) {
			timeout++;
			Sleep(10); //give up time slice to other processes
			if(timeout>=20) {
				flag=true;
			}
		} else {
			PrintDebug("Camera Sent a ");
			PrintDebugChar(buf[i]);
			PrintDebug("\r\n");
			if(buf[i]==ESCAPE_CHAR) {
				i++;
				buf[i]=ESCAPE_CHAR;
			} else if(buf[i]==':') {
				flag=true;
			}
			i++;
		}
	}
	buf[i]=ESCAPE_CHAR;
	buf[i+1]=TERM_CHAR;
	buf[i+2]=NULL;
	i+=2;
	if(timeout>=20) {
		sprintf(buf2,"  TIMEOUT CAMERA ");
		buf2[0] = (char) 255;
		buf2[1] = 55;
		buf2[2] = 2;
		buf2[3] = (char) 255;
		buf2[4] = 55;

		tcpip5000_queue->push2(buf2,5,NothingProcess);
		PrintDebug("\r\nCamera Timeout!\r\n");
	} else {
		PrintDebug("\r\nCamera returned ");
		PrintDebug2(&buf[2],i-4);
		PrintDebug("\r\n");
		tcpip5000_queue->push2(buf,i,NothingProcess);
	}
	return 0;
}


//slow working dumpframe
DWORD DumpFrameProcess(LPVOID lpvoid)
{
	stopDF=false;
	char theBuffer[34646];
	int i=0;
	bool seen3=false;
	int timeout=0;
	bool done=false;
	while(!done && timeout< 30000 && !stopDF) {
		if(!com1->readByte(theBuffer[i])) {
			timeout++;
			if(timeout==30000) {
				PrintDebug("Timedout\r\n");
				done=true;
			} 
			Sleep(0); //give up time slice to other processes	
		} else {
			if(seen3 && theBuffer[i]==':') {
				done=true;
			} 
			if(theBuffer[i]==3) {
				seen3=true;
			}
			timeout=0;
			i++;
		}
	}
	if(stopDF) {
		PrintDebug("Stopped DF\r\n");
		return 0;
	}
	TCPIP5002->sendData2(theBuffer,i);
	sprintf(theBuffer,"Send %d bytes\r\n",i);
	PrintDebug("Dump frame completed successfully\r\n");
	PrintDebug(theBuffer);
	com1->Flush();
	return 0;
}

/*
//faster dump frame
DWORD DumpFrameProcess(LPVOID lpvoid)
{
	int len=0;
	stopDF=false;
	char theBuffer[34646];
	int i=0;
	int curr_i=0;
	bool seen3=false;
	int timeout=0; 
	bool done=false;
	while(!done && timeout< 30000 && !stopDF) {
		len=com1->readString(&theBuffer[i],200);
		if(len==0) {
			timeout++;
//			if(com1->bufLength()==0 && curr_i+50<i) {
//				TCPIP5002->sendData2(&theBuffer[curr_i],1);
//				curr_i+=1;
//			}
			if(timeout==30000) {
				PrintDebug("Timed out\r\n");
				done=true;
			} 
			Sleep(0); //give up time slice to other processes	
		} else {
			if((seen3 || theBuffer[i+len-2]==3) && theBuffer[i+len-1]==':') {
				done=true;
			} 
			if(theBuffer[i+len-1]==3) {
				seen3=true;
			}
			timeout=0;
			i+=len;
		}
	}
	if(stopDF) {
		PrintDebug("Stopped DF\r\n");
		return 0;
	}
	TCPIP5002->sendData2(&theBuffer[curr_i],i-curr_i);
	sprintf(theBuffer,"Send %d bytes\r\n",i);
	PrintDebug("Dump frame completed successfully\r\n");
	PrintDebug(theBuffer);
	com1->Flush();
	return 0;
}
*/

// take visual x y of object and move rover neck to center object incrementally //
void roverTrack(unsigned char x, unsigned char y)
{
	int oldCP = CP;
	int oldCT = CT;

	if(x==0);
	else if(x>60) CP-=3;
	else if(x>50) CP-=2;
	else if(x<20) CP+=3;
	else if(x<30) CP+=2;

	if(y==0);
	else if(y>92) CT+=4;
	else if(y>87) CT+=3;
	else if(y<52) CT-=4;
	else if(y<57) CT-=3;
	
	if(CP<25) CP=25;
	if(CP>240) CP=240;
	if(CT<35) CT=35;
	if(CT>240) CT=240;
	//generate commands here
	char abuf[40];
	if(CP != oldCP || CT != oldCT)
	{
	   sprintf(abuf,"Sending CT %d, CP %d\r\n",CT,CP);
	   PrintDebug(abuf);
	   //change made 6/24 7:00pm by Eric Porter
	   send_rover(0,0,0,CP,CT,IgnoreRoverProcess);
	}

	//send_tilt(CT,IgnoreRoverProcess);
	//send_pan(CP,IgnoreRoverProcess);
}



DWORD TrackProcess(LPVOID lpvoid)
{
	//center the camera
	quittrack=false;
	// CP=145; // let them be for now...
	//CT=145; // let them be for now...
	//roverTrack(0,0);
	int state=0;
	char Byte;
	int cycCount=0;
	char abuf[50];
	unsigned char x,y, width, height, pix, conf, bufbyte;
	while( !quittrack) {
		if(com1->readByte(Byte)) {
			bufbyte = (unsigned char)Byte;
			if(bufbyte==255) {
				state=1;
			} else if(state==1) {
				state=2;
			} else if(state==2) {					
				state=3;
				x=bufbyte;					
			} else if(state==3) {
				state=4;
				y=bufbyte;
				roverTrack(x,y); // THIS IS WHERE IT TRACKS, as soon as possible //
				cycCount += 1; cycCount = cycCount%2;
			} else if(state==4) {
				state=5;
				width=bufbyte;
			} else if(state==5) {
				state=6;
				height=bufbyte;
			} else if(state==6) {
				state=7;
				width = bufbyte - width;
			} else if(state==7) {
				state=8;
				height= bufbyte - height;
			} else if(state==8) {
				state=9;
				pix = bufbyte;
			} else if(state==9) {
				state=0;
				conf = bufbyte;
				if (cycCount == 0) { // Once every N cycles send Cam Stats to mainSocket //
					abuf[0]=-1; abuf[1]=CP; abuf[2]=CT; abuf[3]=x; abuf[4]=y; abuf[5]=width;
					abuf[6]=height; abuf[7]=pix; abuf[8]=conf; abuf[9]='\r';
					TCPIP5003->sendData2(abuf,10);
					Sleep(20);
				} //end if on sending to Notebook cam stats
			}
			//buffer+=dwBytesTransferred;
		} else {
			Sleep(10);
		}
	} // end while () //
	PrintDebug("Ending Tracking\r\n");
	com1->writeByte('\r');
	Sleep(250);
	com1->Flush();
	return true;
}

DWORD RoverProcess(LPVOID lpvoid)
{
	PrintDebug("Entering Rover Process\r\n");
	Sleep(0);
	bool flag=false;
	int count=0;
	char buf[100];
	char buf2[200];
	int i=2;
	buf[0]=ESCAPE_CHAR;
	buf[1]=TERM_CHAR;
	buf[i]=0;
	int timeout=0;
	while(i<96 && !flag) {
		if(!com2->readByte(buf[i])) {
			timeout++;
			Sleep(2);
			if(timeout==15) {  // timeout changed to 40 (rgockley 6/17 3:37pm)
				flag=true;
			}
		} else {
			//PrintDebug("Rover Sent a ");
			//PrintDebugChar(buf[i]);
			//PrintDebug("\r\n");
			count++;
			if(buf[i]==ESCAPE_CHAR) {
				i++;
				buf[i]=ESCAPE_CHAR;
			}
			if(count==PACKET_LENGTH) { // was 23
				sprintf(buf2, "Rover is done sending data. timeout = %d\r\n", timeout);
				PrintDebug(buf2);
				flag=true;
			}
			i++;
		}
	}
	buf[i]=ESCAPE_CHAR;
	buf[i+1]=TERM_CHAR;
	buf[i+2]=NULL;
	i+=2;
	if(timeout>=15) {
				// we got a rover timeout. let them know
		PrintDebug("Rover Timed out\r\n");
		PrintDebugAscii(buf,i+2);
		PrintDebug("\r\n");
		buf2[0] = ESCAPE_CHAR; buf2[1] = TERM_CHAR; buf2[2] = 2; buf2[3] = ESCAPE_CHAR;
		buf2[4] = TERM_CHAR;

		//sprintf(buf2,"\255\0TIMEOUT ROVER ");
		//for(int j=2; j<=i; j++) {
		//	buf2[j+17]=buf[j];
		//}
		tcpip5001_queue->push2(buf2,5,NothingProcess);
	} else {
		PrintDebug("\r\nRover returned ");
		PrintDebugAscii(buf,i);
		PrintDebug("\r\n");
		tcpip5001_queue->push2(buf,i,NothingProcess);
	}
	return 0;
}

//just sends it to the rover and gets back the return to keep the stream clear
DWORD IgnoreRoverProcess(LPVOID lpvoid)
{
	Sleep(0);
	bool flag=false;
	int count=0;
	char buf[100];
	int i=2;
	buf[0]=ESCAPE_CHAR;
	buf[1]=TERM_CHAR;
	buf[i]=0;
	int timeout=0;
	while(i<96 && !flag) {
		if(!com2->readByte(buf[i])) {
			timeout++;
			Sleep(2);
			if(timeout==15) {//changed by eporter 7/4/02
				flag=true;
			}
		} else {
			count++;
			if(buf[i]==ESCAPE_CHAR) {
				i++;
				buf[i]=ESCAPE_CHAR;
			}
			if(count==PACKET_LENGTH) {
				flag=true;
			}
			i++;
		}
	}
	com2->Flush();
	return 0;
}

DWORD ClearCameraProcess(LPVOID lpvoid)
{
	com1->Flush();
	return 0;
}

DWORD ClearRoverProcess(LPVOID lpvoid)
{
	com2->Flush();
	return 0;
}

DWORD CameraFollowProcess(LPVOID lpvoid)
{
	char buf[40];
	char byte[7];
	char input;
	int bp=0;
	bStopFollow=false;
	sprintf(buf,"starting camera follow process\r\n");
	tcpip5000_queue->push(buf,NothingProcess);
	while(!bStopFollow) {
		do {
			while (com1->readByte2() != -1);
		} while (com1->readByte2() != 'C');
		
		for(bp=0; bp<6; bp++) {
			while(!com1->readByte(input));
			byte[bp]=input;
		}
		int diff=(unsigned char)byte[0] + (unsigned char)byte[2] - 80;
//		int diff=(unsigned char)byte[0]-40;
		if(diff>0) {
				send_dir((unsigned char)(diff/5),NothingProcess);
//			send_dir(5,NothingProcess);
		} else {
			send_dir((unsigned char)(255+(signed int)(diff/5)),NothingProcess);
//			send_dir(250,NothingProcess);
		}
		sprintf(buf,"Got input of %d %d %d %d %d %d\r\n",byte[0],byte[1],
			byte[2],byte[3],byte[4],byte[5]);
		tcpip5000_queue->push(buf,NothingProcess);
	}

	send_rover(0,0,0,150,120,NothingProcess);
	return 0;
}

DWORD FollowLineProcess(LPVOID lpvoid)
{

	char buf[40];


	send_rover(100,0,0,150,90,NothingProcess);
	
	com1->Flush();
	sprintf(buf,"\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"CR 18 40 17 2 19 33\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"rm 1\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"mm 0\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"nf 1\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"sw 1 1 80 40\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"pm 0\r");
	com1_queue->push(buf, CameraProcess);
	sprintf(buf,"tc 0 255 150 255 0 255\r");
	com1_queue->push(buf, CameraFollowProcess);
	//com1_queue->push(buf, CameraProcess);
	sprintf(buf,"\r\r\r");
	com1_queue->push(buf,ClearCameraProcess);

	return 0;
}

void stop_follow()
{
	bStopFollow=true;
}

//rover commands
void send_rover(unsigned char v, unsigned char d, unsigned char b, 
								unsigned char cp, unsigned char ct, LPTHREAD_START_ROUTINE thread)
{
	unsigned char buf[10];
	buf[0]=255;
	buf[1]=v;
	buf[2]=d;
	buf[3]=b;
	buf[4]=cp;
	buf[5]=ct;
	unsigned char mask=0;
	if(v!=0) mask+=1;
	if(d!=0) mask+=2;
	if(b!=0) mask+=4;
	if(cp!=0) mask+=8;
	if(ct!=0) mask+=16;
	buf[6]=mask;
	buf[7]=(unsigned char)((v+d+b+cp+ct+mask)%256);
	buf[8]=255;
	buf[9]=0;
	com2_queue->push2((char*)buf,9,thread);
}

void send_rover2(unsigned char v, unsigned char d, unsigned char b, 
								unsigned char cp, unsigned char ct, unsigned char mask,
								LPTHREAD_START_ROUTINE thread)
{
	unsigned char buf[10];
	buf[0]=255;
	buf[1]=v;
	buf[2]=d;
	buf[3]=b;
	buf[4]=cp;
	buf[5]=ct;
	buf[6]=mask;
	buf[7]=(unsigned char)((v+d+b+cp+ct+mask)%256);
	buf[8]=255;
	buf[9]=0;
	com2_queue->push2((char*)buf,9,thread);
}

void send_vel(unsigned char v, LPTHREAD_START_ROUTINE thread)
{
	if(v==0) {
		send_rover2(0,0,0,0,0,1,thread);
	} else {
		send_rover(v,0,0,0,0,thread);
	}
}

void send_dir(unsigned char d, LPTHREAD_START_ROUTINE thread)
{
	if(d==0) {
		send_rover2(0,0,0,0,0,2,thread);
	} else {
		send_rover(0,d,0,0,0,thread);
	}
}

void send_boom(unsigned char b, LPTHREAD_START_ROUTINE thread)
{
	if(b==0) {
		send_rover2(0,0,0,0,0,4,thread);
	} else {
		send_rover(0,0,b,0,0,thread);
	}
}

void send_pan(unsigned char cp, LPTHREAD_START_ROUTINE thread)
{
	if(cp==0) {
		send_rover2(0,0,0,0,0,8,thread);
	} else {
		send_rover(0,0,0,cp,0,thread);
		}
}

void send_tilt(unsigned char ct, LPTHREAD_START_ROUTINE thread)
{
	if(ct==0) {
		send_rover2(0,0,0,0,0,16,thread);
	} else {
		send_rover(0,0,0,0,ct,thread);
	}
}

